#cs ----------------------------------------------------------------------------

 Remmanaut, the autoit RMM tool

 Script function:		Server launcher, GUI with status
 Version:				0.2.3

 Author:				Faldo / Erik Ribbhammar
 UDF Credits:			lod3n (_RunReadStd), dantay9 (TCP File Transfer),
						Prog@ndy (MySQL), Greg Laabs (_http)
 Helping Credits:

#ce ----------------------------------------------------------------------------
#NoTrayIcon
#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include <array.au3>


$AgentCon = "Agent connector"
$MgmCon = "Management connector"
$SrvMain = "Server maintenance"
$TransCon = "Transfer connector"
$TotalServices = 4

Global $ServiceName[$TotalServices+1] = [$TotalServices, $AgentCon, $MgmCon, $SrvMain, $TransCon]
Global $ProcessName[$TotalServices+1] = [$TotalServices]

For $s = 1 to $TotalServices
	$ProcessName[$s] = "Remmanaut-"&$ServiceName[$s]&".exe"
Next

Global $Label[Ubound($ProcessName)] = [$ProcessName[0]]
Global $Status[Ubound($ProcessName)] = [$ProcessName[0]]
Global $Button[Ubound($ProcessName)] = [$ProcessName[0]]

;Create Main GUI
$mGUI = GUICreate("Remmanaut launcher", 300, 200)

$y_coord = 14
For $l = 1 to $TotalServices
	$Label[$l] = GUICtrlCreateLabel($ServiceName[$l]&":", 10, $y_coord+4, 170)
	GUICtrlCreateGroup ( "", 5, $y_coord-6, 200, 30)
	$Status[$l] = GUICtrlCreateLabel("", 150, $y_coord+4, 50, 15)
	$Button[$l] = GUICtrlCreateButton ( "Start", 230, $y_coord-1, 70)
	$y_coord = $y_coord+30
Next

$StartAll = GUICtrlCreateButton ( "Start all", 30,150 , 70)
$StopAll = GUICtrlCreateButton ( "Stop all", 110, 150, 70)

;Start Log-GUI if defined in settings.ini
If IniRead ( "settings.ini", "general", "log-gui", "1" ) = 1 then
	Run ("Log-GUI.exe")
	WinWait ("Remmanaut Log")
	$WinPos = WinGetPos ( "Remmanaut Log" )
	WinMove($mGUI, "", $WinPos[0]+520, $WinPos[1])
EndIf

;Initial status check
Checkrunning()

GUISetState(@SW_SHOW, $mGUI)
AdlibRegister("Checkrunning", 1000)

;Main GUI loop
While 1
	$msg = GUIGetMsg()
	Select
		Case $msg>=$Button[1] And $msg<=$Button[$TotalServices]
			$Button_pushed = _ArraySearch ( $Button, $msg)
			If ProcessExists($ProcessName[$Button_pushed]) then
				ProcessClose($ProcessName[$Button_pushed])
			Else
				Run($ProcessName[$Button_pushed], @ScriptDir)
			EndIf

		Case $msg= $StartAll
			For $a = 1 to $TotalServices
				If NOT ProcessExists($ProcessName[$a]) then Run($ProcessName[$a], @ScriptDir)
			Next

		Case $msg=$StopAll
			For $a = 1 to $TotalServices
				ProcessClose($ProcessName[$a])
			Next

		Case $msg=$GUI_EVENT_CLOSE
			Exit

	EndSelect
WEnd




Func Checkrunning()
	For $i = 1 to $TotalServices
		If ProcessExists($ProcessName[$i]) then
			GUICtrlSetData( $Status[$i], "Running")
			GUICtrlSetData( $Button[$i], "Stop")

		Else
			GUICtrlSetData( $Status[$i], "")
			GUICtrlSetData( $Button[$i], "Start")
		EndIf
	Next

EndFunc